<?php 
/*******************************
 * Custom Widget Class
 * This Widget Will Display Page 
 * Link and Clear List Button
 *******************************/

class Enquiry_Widget extends WP_Widget {

	//Initialization
	function __construct() {
		parent::__construct(
			'enquiry-widget-gts', // Base ID
			__('Enquiry List and Link', 'gts'), // Name
			array( 'description' => __( 'This widget holds your product enquiry request tracks. Place it in your sidebar to display product enquiry list and clear list options.', 'gts' ), ) // Args
		);
	}

	//Display Widget
	public function widget( $args, $instance ) {
		
		extract($args);
			
		// Get the title and prepare it for display
		$title = apply_filters('widget_title', $instance['title']);
		
		// Get the ad images
		$enqBtnLabel  = $instance['enq_button_title'];
		$enqBtnLink   = $instance['enq_button_link'];
		$clrBtnLabel  = $instance['clr_button_title'];
		$noItemsLabel = $instance['no_item_label'];

		define('ENQ_BTN_LINK', $enqBtnLink);
		define('ENQ_BTN_LABEL', $enqBtnLabel);

		echo $before_widget;
			
			if ($title) {
				echo $before_title . $title . $after_title;
			}

			?>
			
			<div class="woocommerce">

			<div class="enq-cart-block widget_shopping_cart">
			<!-- Widget Output Content -->
			<?php if ( isset($_SESSION['products_ids']) && $_SESSION['products_ids'] != "" ) : 

				$gtsWooCatData = get_option('woocat_opt');

				$btnUrl 		= "";
			    $btnLabel 		= __("Quote Me Now","gts");
			    $clrBtnLabel	= __('Clear List', 'gts');

			    if( isset( $gtsWooCatData['enq_page_url'] ) )
			    {
			    	$btnUrl 	= $gtsWooCatData['enq_page_url'];
			    }
			    if( isset( $gtsWooCatData['enq_btn_label'] ) ){
			    	$btnLabel 	= $gtsWooCatData['enq_btn_label'];
			    }

				$output = "";

		    	$ids = explode("-;-", $_SESSION["products_ids"]);

				$output .= '<ul class="cart_list product_list_widget">';
						
				//asort($ids);

				$count = 0;

				foreach( $ids as $id) :

					if( $id != "" || $id != NULL ) :
						$output .= '<li>
							<a href="#" data-id="'.$id.'" class="remove enq-item-remove" title="Remove this item">
								x
							</a>
							<a href="'.get_the_permalink( $id ).'">'.
							get_the_post_thumbnail( $id, 'shop_catalog' ).get_the_title( $id ).'
							</a>
						</li>';

						$count++;
					endif;

				endforeach;

				$output .= '</ul>
				<p class="total">
					<strong>'.__("Total Item(s)", "gts").' :</strong> 
					<span class="amount">'.$count.'</span>
				</p>
				<p class="buttons">
					<a class="button wc-forward gts-enq-page-link" href="'.$btnUrl.'">'.$btnLabel.'</a>
					<a class="button wc-forward gts-clear-list" href="#">'.$clrBtnLabel.'</a>
				</p>';

				echo $output;

			?>

			<?php else: ?>
				<p><?php echo $noItemsLabel; ?></p>
			<?php endif ?>

			</div>

			</div>

			<?php

		echo $after_widget;
	}

	//Widget Form
	public function form( $instance ) {
		
		$defaults = array(
				'title' => __('Enquiry Cart', 'gts'),
				'enq_button_title' => __('Make Enquiry', 'gts'),
				'enq_button_link' => '',
				'clr_button_title' => __('Clear List', 'gts'),
				'no_item_label' => __('Enquiry list is empty now.', 'gts')
			);
			
		$instance = wp_parse_args((array) $instance, $defaults);

		?>
		<!-- Widget Title -->
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>">
		</p>
		<!-- Button Title -->
		<p>
			<label for="<?php echo $this->get_field_id( 'enq_button_title' ); ?>"><?php _e( 'Enquiry Page Link Title:' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'enq_button_title' ); ?>" name="<?php echo $this->get_field_name( 'enq_button_title' ); ?>" type="text" value="<?php echo esc_attr( $instance['enq_button_title'] ); ?>">
		</p>
		<!-- Button Link -->
		<p>
			<label for="<?php echo $this->get_field_id( 'enq_button_link' ); ?>"><?php _e( 'Enquiry Page Link:' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'enq_button_link' ); ?>" name="<?php echo $this->get_field_name( 'enq_button_link' ); ?>" type="text" value="<?php echo esc_attr( $instance['enq_button_link'] ); ?>">
		</p>
		<!-- Clear Title -->
		<p>
			<label for="<?php echo $this->get_field_id( 'clr_button_title' ); ?>"><?php _e( 'Clear Button Title:' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'clr_button_title' ); ?>" name="<?php echo $this->get_field_name( 'clr_button_title' ); ?>" type="text" value="<?php echo esc_attr( $instance['clr_button_title'] ); ?>">
		</p>
		<!-- No item Label -->
		<p>
			<label for="<?php echo $this->get_field_id( 'no_item_label' ); ?>"><?php _e( 'No item text:' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'no_item_label' ); ?>" name="<?php echo $this->get_field_name( 'no_item_label' ); ?>" type="text" value="<?php echo esc_attr( $instance['no_item_label'] ); ?>">
		</p>
		<?php 
	}

	//Widgets events handler
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		//Title
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

		//Other Fields
		$instance['enq_button_title'] = $new_instance['enq_button_title'];
		$instance['enq_button_link']  = $new_instance['enq_button_link'];
		$instance['clr_button_title'] = $new_instance['clr_button_title'];
		$instance['no_item_label'] 	  = $new_instance['no_item_label'];

		return $instance;
	}

} //End of Class: Enquiry_Widget


/*******************************
 * Registering Widget With System
 *******************************/

function register_enquiry_widget() {
    register_widget( 'Enquiry_Widget' );
}
add_action( 'widgets_init', 'register_enquiry_widget' );


/*******************************
 * Ajax Hanler: Widget Options 
 *******************************/
add_action( 'wp_ajax_widget_clear_action', 'widget_clear_action' );
add_action( 'wp_ajax_nopriv_widget_clear_action', 'widget_clear_action' );

function widget_clear_action() {

    //Grabbing Post Data
    $postedDecision = $_POST["clear_list"];

    $responseResult = false;

    if( $postedDecision == 'yes'){
    	unset($_SESSION['products']);
    	unset($_SESSION['products_ids']);
    	$responseResult = true;
    }

    //Setting Response
    $data = array();
    if ( $responseResult ) {

    	$data['result'] = 1;
    	$data['result_msg'] = "List successfully cleared.";

    }
    else{

    	$data['result'] = 2;
    	$data['result_msg'] = "Opps! Operation failed.";

    }

    //json response
    echo json_encode($data);

	die();
}

/*******************************
 * Ajax Hanler: Widget Options
 * Clear Single Item From Cart 
 *******************************/
add_action( 'wp_ajax_widget_clear_item_action', 'widget_clear_item_action' );
add_action( 'wp_ajax_nopriv_widget_clear_item_action', 'widget_clear_item_action' );

function widget_clear_item_action() {

    //Grabbing Post Data
    $postedDecision = $_POST["clear_list"];
    $itemId = $_POST["item_id"];
    //$redirectURL = $_POST["redirect"];

    $responseResult = false;

    if( $postedDecision == 'yes' && $itemId != ""){
    	$currentItems = $_SESSION['products_ids'];
    	$currentItems2 = str_replace('-;-'.$itemId, '', $currentItems);
    	$_SESSION['products_ids'] = str_replace( $itemId, '', $currentItems2);
    	$responseResult = true;
    }

    //Setting Response
    $data = array();
    if ( $responseResult ) {

    	$data['result'] = 1;
    	$data['result_msg'] = __('Item cleared', 'gts');

    }
    else{

    	$data['result'] = 2;
    	$data['result_msg'] = __('Opps! Operation failed', 'gts');

    }

    //json response
    echo json_encode($data);

	die();
}

/*******************************
 * Ajax Hanler: Widget Options
 * Clear Single Item From Form 
 *******************************/
add_action( 'wp_ajax_form_clear_item_action', 'form_clear_item_action' );
add_action( 'wp_ajax_nopriv_form_clear_item_action', 'form_clear_item_action' );

function form_clear_item_action() {

    //Grabbing Post Data
    $postedDecision = $_POST["clear_list"];
    $itemId = $_POST["item_id"];
    //$redirectURL = $_POST["redirect"];

    $responseResult = false;

    if( $postedDecision == 'yes' && $itemId != ""){

    	$currentItems = $_SESSION['products_ids'];

    	$currentItems2 = str_replace('-;-'.$itemId, '', $currentItems);
    	$_SESSION['products_ids'] = str_replace( $itemId, '', $currentItems2);
    	$responseResult = true;
    }

    //Setting Response
    $data = array();
    if ( $responseResult ) {

    	$data['result'] = 1;
    	$data['result_msg'] = __('Item cleared', 'gts');

    }
    else{

    	$data['result'] = 2;
    	$data['result_msg'] = __('Opps! Operation failed', 'gts');

    }

    //json response
    echo json_encode($data);

	die();
}