<?php
/*******************************
 * Integration with 3rd party plugins, like CF7
 *******************************/

/*******************************
 * CF7
 *******************************/

//Check if CF7 is active
if( defined('WPCF7_VERSION')){
	wpcf7_add_form_tag('enqproducts_list', 'wpcf7_enqproducts_shortcode_handler', true);
}

//CF7 Shortcode Handler
function wpcf7_enqproducts_shortcode_handler($tag) {
	
	if (!is_object($tag)) return '';

	$name = $tag['name'];
	if (empty($name)) return '';

	//Checking products, exploding and then adding as option
	$options = "";
	$output = "";
	
	if( isset($_SESSION["products_ids"]) && $_SESSION["products_ids"] != "" ){
		$total_items = explode("-;-", $_SESSION["products_ids"]);

		$ids = explode("-;-", $_SESSION["products_ids"]);

		$output .= '<div class="woocommerce"><ul class="cart_list_form product_list_widget">';
				
		//asort($ids);

		$count = 0;

		foreach( $ids as $id) :

			if( $id != "" || $id != NULL ) :
				$output .= '<li>
					<a href="#" data-id="'.$id.'" class="remove enq-item-remove" title="Remove this item">
						x
					</a>
					<a href="'.get_the_permalink( $id ).'">'.
					get_the_post_thumbnail( $id, 'shop_catalog' ).get_the_title( $id ).'
					</a>
				</li>';

				$count++;
			endif;

		endforeach;

		$output .= '</ul>
		<p class="total">
			<strong>'.__("Total Item(s)", "gts").' :</strong> 
			<span class="amount">'.$count.'</span>
		</p>

		</div>';

		$html = $output;
	}
	else{
		$html = '<strong>'.__('List empty! Please add some item(s) first in your enquiry list.', 'gts').'</strong>';
	}

	return $html;
}

//2nd Shortcode, for field values
if( defined('WPCF7_VERSION')){
	wpcf7_add_form_tag('enqproducts_field', 'wpcf7_enqproducts_field_shortcode_handler', true);
}

//CF7 Shortcode Handler
function wpcf7_enqproducts_field_shortcode_handler($tag) {

	if ( !is_object($tag) ) return '';

	$name = $tag['name'];
	if (empty($name)) return '';

	//Checking products, exploding and then adding as option
	$options = "";
	if( isset($_SESSION["products_ids"]) && $_SESSION["products_ids"] != "" ){

		$ids = explode("-;-", $_SESSION["products_ids"]);
				
		asort($ids);

		$count = 0;

		/*foreach (  $ids as $id ) {
			if( $id != "" || $id != NULL ) :
				$serialNo = $count+1;
				$options .= "<option selected>".$serialNo.")".get_the_title( $id )."(ID-".$id.")"."</option>";
				$count++;
			endif;
		}

		$html = '<select name="' . $name . '[]" multiple class="enq-products" data-placeholder="Choose an Item" aria-required="true">
            '.$options.'
          </select>';*/

        foreach (  $ids as $id ) {
			if( $id != "" || $id != NULL ) :
				$serialNo = $count+1;
				$options .= "".$serialNo.")".get_the_title( $id )."(ID-".$id.")"."\r\n";
				$count++;
			endif;
		}

		$html = '<textarea name="' . $name . '" class="enq-products" aria-required="true">
            '.$options.'
          </textarea>';


	}
	else{

		$html = '';
		
	}

	return $html;
}

