/*Form Action Handling*/
jQuery(document).ready(function($) {
	$('#input-submit').on('click', function(event){
	
		event.preventDefault();
		
		var currentClickedBtn = $(this);
		
		var forwardFlag = true;
		$(".status-error").remove();
		$(".status-success").remove();
		$(".status-error2").remove();

		//Clearing Messages
		$("#input-name").on('keypress', function(){
			$(this).siblings('.status-error').fadeOut();
		});
		$("#input-email").on('keypress', function(){
			$(this).siblings('.status-error').fadeOut();
		});
		$("#input-subject").on('keypress', function(){
			$(this).siblings('.status-error').fadeOut();
		});
		$("#input-message").on('keypress', function(){
			$(this).siblings('.status-error').fadeOut();
		});

		var name     = $("#input-name").val();
		var email    = $("#input-email").val();
		var subject  = $("#input-subject").val();
		var products = $("#input-porducts").val();
		var message  = $("#input-message").val();
		var toEmail  = $("#input-toemail").val();

		//If Name is empty
		if( name === "" ){
			$("#input-name").after('<p class="status-error">This field is required.</p>');
			forwardFlag = false;
		}

		//If invalid email
		var emailIsValid = IsEmail(email);

		if( emailIsValid == false || email === "" ){
			$("#input-email").after('<p class="status-error">Email address empty or invalid.</p>');
			forwardFlag = false;
		}

		//If Subject is empty
		if( subject === "" ){
			$("#input-subject").after('<p class="status-error">This field is required.</p>');
			forwardFlag = false;
		}

		//If message is empty
		if( message === "" ){
			$("#input-message").after('<p class="status-error">This field is required.</p>');
			forwardFlag = false;
		}

		//If product list is empty
		if( products === "" || products === null ){
			$("#input-porducts").after('<p class="status-error">Required at least one item.</p>');
			forwardFlag = false;
		}

		if( products === undefined ){
			$(".no-product-text").after('<p class="status-error">Required at least one item.</p>');
			forwardFlag = false;
		}

		if( forwardFlag === true ){
			
			currentClickedBtn.after('<div class="gts-processing"></div>');
			
			var data = {
				'action'		: 'enq_form_action',
				'post_name'  	: name,
				'post_email'  	: email,
				'post_subject'  : subject,
				'post_products' : products,
				'post_message' 	: message,
				'post_toemail' 	: toEmail,
			};

			$.post(ajaxurl, data, function(response) {
				var obj = jQuery.parseJSON( response );
				if( obj.result === 1 ){
					
					$('body .gts-processing').remove();
					
					$('.gts-form-status').append("<span class='status-success'>" +obj.result_msg+ "</span>");
					
				}
				if( obj.result === 2 ){
					
					$('body .gts-processing').remove();
					
					$('.gts-form-status').append("<span class='status-error2'>" +obj.result_msg+ "</span>");
				}	
			});
		}


	});

	function IsEmail(email) {
	  var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
	  return regex.test(email);
	}

});