<?php

  //include the main class file
  require_once("admin-page-class/admin-page-class.php");
  
  
   $config = array(    
    'menu'           => array('top' => 'gts-woocat-opt'),             //sub page to settings page
    'page_title'     => __('WC Enquiry Options','apc'),       //The name of this page 
    'capability'     => 'edit_themes',         // The capability needed to view the page 
    'option_group'   => 'woocat_opt',       //the name of the option to create in the database
    'id'             => 'woocat_opt_page',            // meta box id, unique per page
    'fields'         => array(),            // list of fields (can be added by field arrays)
    'local_images'   => false,          // Use local or hosted images (meta box images for add/remove)
	'icon_url'   => plugin_dir_url(__FILE__).'images/settings.png', // Use local or hosted images (meta box images for add/remove)
    'use_with_theme' => false          //change path if used with theme set to true, false for a plugin or anything else for a custom path(default false).
  );  
  
  /**
   * instantiate your admin page
   */
  $options_panel = new BF_Admin_Page_Class($config);
  $options_panel->OpenTabs_container('');
  
  /**
   * define your admin page tabs listing
   */
  $options_panel->TabsListing(array(
    'links' => array(
      'options_settings' =>  __('Basic Settings','apc'),
      'options_color' =>  __('Color Settings','apc'),
    )
  ));
  
  
  $options_panel->OpenTab('options_settings');

  /**
   * Add fields to your admin page first tab
   * 
   * Simple options:
   * input text, checbox, select, radio 
   * textarea
   */
  //title
  $options_panel->Title(__("WC Enquiry Settings","apc"));
  //An optionl descrption paragraph
  $options_panel->addParagraph(__("Here you can manage custom setting.","apc"));
  
  //disable catalog
  $options_panel->addCheckbox('disable_catalog',array('name'=> __('Disable Catalogue Mode ','apc'), 'std' => false, 'desc' => __('Make this field \'On\' if you want to keep catalog mode disabled.','apc')));

  //shop mode with enquiry
  $options_panel->addCheckbox('shop_enquiry',array('name'=> __('Keep shop mode with Enquiry Option?','apc'), 'std' => false, 'desc' => __('Make this field \'On\' if you want to keep shop mode ON with product enquiry feature.','apc')));
  
  //hide price tag
  $options_panel->addCheckbox('hide_price',array('name'=> __('Remove Price Tag From Site ','apc'), 'std' => false, 'desc' => __('Make this field \'On\' if you want to hide price tag from all products.','apc')));
  
  //enable custom button
  $btn_val[] = $options_panel->addText('btn_text',array('name'=> __('Custom Button Text Label','apc'), 'std'=> 'Add to Quote', 'desc' => __('Text label for custom enquiry button.','apc') ), true);
  $btn_val[] = $options_panel->addText('btn_radius', array('name'=> __('Custom Button Border Radius ','apc'), 'std'=> '0', 'desc' => __('Border radius of custom button, default is 0. You can set value like 3, 5, 10 etc.','apc')), true);
  $options_panel->addCondition('custom_btn',
      array(
        'name'   => __('Enable Enquiry Button? ','apc'),
        'desc'   => __('<small>Turn ON if you want to display a product enquiry button.','apc'),
        'fields' => $btn_val,
        'std'    => true
      ));
	  
  //hide btn from sidebar
  $options_panel->addCheckbox('sidebar_btn_hide',array('name'=> __('Hide custom button form Sidebar Widgets ','apc'), 'std' => false, 'desc' => __('Make this field \'On\' if you want to hide custom button from widgets/sidebar.','apc')));
  
  //hide btn from sidebar
  $options_panel->addCheckbox('full_btn_hide',array('name'=> __('Hide custom button form Full Site','apc'), 'std' => false, 'desc' => __('Make this field \'On\' if you want to hide custom button from full site.','apc')));

  //hide btn from sidebar
  $options_panel->addSelect('popup_type',array('alert'=>'Alert Window','inline'=>'Inline Notification'),array('name'=> __('Notification Type ','apc'), 'std'=> array('inline'), 'desc' => __('This field will define how your users will see notification after clicking on quote button.','apc')));
	  
  //Enquiry Page Link
  $options_panel->addText('enq_btn_label',array('name'=> __('Enquiry page link title ','apc'), 'std'=> 'Quote Me Now','apc') );

  $options_panel->addText('enq_page_url',array('name'=> __('URL for Enquiry page link ','apc'), 'std'=> '', 'desc' => __('URL for enquiry button.','apc') ) );

  $options_panel->addText('enq_continue_label',array('name'=> __('Continue shopping button label ','apc'), 'std'=> 'Keep Browsing', 'desc' => __('Text label for continue button.','apc') ) );
  
  
  /**
   * Close first tab
   */   
  $options_panel->CloseTab();
  
  $options_panel->OpenTab('options_color');

  /**
   * Add fields to your admin page first tab
   * 
   * Simple options:
   * input text, checbox, select, radio 
   * textarea
   */
  //title
  $options_panel->Title(__("Color Settings","apc"));
  //An optionl descrption paragraph
  $options_panel->addParagraph(__("Here you can manage custom color settings for enquiry or quote button.","apc"));

  //Button BG Color
  $button_color[] = $options_panel->addColor(
                                      'btn_bg_clr',
                                      array(
                                        'name'=> __('Button Background Color','apc'), 
                                        'desc' => __('Background color of custom button.','apc'), 
                                        'std' => '#f7f6f7'
                                        ), 
                                      true);
  //Button BG Color on Mouseover
  $button_color[] = $options_panel->addColor(
                                      'btn_bg_hover',
                                      array(
                                        'name'=> __('Button Background Color on Mouse Over','apc'), 
                                        'desc' => __('Background color of button on mouseover.','apc'), 
                                        'std' => '#d4cdd2'
                                        ), 
                                      true);
  //Button Text Color
  $button_color[] = $options_panel->addColor(
                                      'btn_text_clr',
                                      array(
                                        'name'=> __('Button Text Color ','apc'), 
                                        'desc' => __('Text color of button in normal state','apc'), 
                                        'std' => '#5e5e5e'
                                        ), 
                                      true);
  //Button Text Color on Mouseover
  $button_color[] = $options_panel->addColor(
                                      'btn_text_clr_hover',
                                      array(
                                        'name'=> __('Button Text Color on Mouse Over ','apc'), 
                                        'desc' => __('Text color of button in mouseover state.','apc'), 
                                        'std' => '#5e5e5e'
                                        ), 
                                      true);
  //Button Border Color
  $button_color[] = $options_panel->addColor(
                                      'btn_border_clr',
                                      array(
                                        'name'=> __('Button Border Color ','apc'), 
                                        'desc' => __('Border color of button in normal state.','apc'), 
                                        'std' => '#c8bfc6'
                                        ), 
                                      true);
  //Button Border Color on Mouseover
  $button_color[] = $options_panel->addColor(
                                      'btn_border_clr_hover',
                                      array(
                                        'name'=> __('Button Border Color on Mouse Over ','apc'), 
                                        'desc' => __('Border color of button in mouseover state.','apc'), 
                                        'std' => '#c8bfc6'
                                        ), 
                                      true);
  //Disable Button Box Shadow
  $button_color[] = $options_panel->addCheckbox(
                                      'btn_box_shadow_val',
                                      array(
                                        'name'=> __('Disable box shadow?','apc'), 
                                        'desc' => __('Make this field ON to disable box shadow.','apc'), 
                                        'std' => false
                                        ), 
                                      true);
  //Disable Button Text Shadow
  $button_color[] = $options_panel->addCheckbox(
                                      'btn_txt_shadow_val',
                                      array(
                                        'name'=> __('Disable text shadow?','apc'), 
                                        'desc' => __('Make this field ON to disable text shadow.','apc'), 
                                        'std' => false
                                        ), 
                                      true);


  $options_panel->addCondition('custom_btn_clr',
      array(
        'name'   => __('Enable Custom Color for Button? ','apc'),
        'desc'   => __('<small>Turn ON if you want to customize button.','apc'),
        'fields' => $button_color,
        'std'    => false
      ));
  
  
  $options_panel->CloseTab();


  